// priority: 100
onEvent('recipes', (event) => {
    //Biofuel additions
    const biofuel = (input, outputAmount) => {
        event.recipes.mekanismCrushing(outputAmount.toString() + 'x mekanism:bio_fuel', input)
    }

    //Dried salt to salt block
    event.recipes.mekanismPurifying('mekanism:block_salt', 'biomesoplenty:dried_salt', {gas: 'mekanism:oxygen', amount: 1})

    //Tin
    event.recipes.mekanismCombining('thermal:tin_ore', '8x thermal:raw_tin', 'minecraft:cobblestone')
    event.recipes.mekanismCombining('thermal:deepslate_tin_ore', '8x thermal:raw_tin', 'minecraft:cobbled_deepslate')

    //Nickel
    event.recipes.mekanismCombining('thermal:nickel_ore', '8x thermal:raw_nickel', 'minecraft:cobblestone')
    event.recipes.mekanismCombining('thermal:deepslate_nickel_ore', '8x thermal:raw_nickel', 'minecraft:cobbled_deepslate')

    //Lead
    event.recipes.mekanismCombining('thermal:lead_ore', '8x thermal:raw_lead', 'minecraft:cobblestone')
    event.recipes.mekanismCombining('thermal:deepslate_lead_ore', '8x thermal:raw_lead', 'minecraft:cobbled_deepslate')

    //Silver
    event.recipes.mekanismCombining('thermal:silver_ore', '8x thermal:raw_silver', 'minecraft:cobblestone')
    event.recipes.mekanismCombining('thermal:deepslate_silver_ore', '8x thermal:raw_silver', 'minecraft:cobbled_deepslate')

    //Dim Shards
    event.recipes.mekanismCombining('rftoolsbase:dimensionalshard_end', '8x rftoolsbase:dimensionalshard', '#forge:end_stones')
    event.recipes.mekanismCombining('rftoolsbase:dimensionalshard_overworld', '8x rftoolsbase:dimensionalshard', 'minecraft:cobblestone')

    //QoL Recipes for clearing creative items
    event.shapeless('mekanism:creative_bin', Item.of('mekanism:creative_bin').ignoreNBT());
    event.shapeless('mekanism:creative_fluid_tank', Item.of('mekanism:creative_fluid_tank').ignoreNBT());
    event.shapeless(Item.of('mekanism:creative_energy_cube', '{mekData:{EnergyContainers:[{Container:0b,stored:"18446744073709551615.9999"}]}}'), Item.of('mekanism:creative_energy_cube').ignoreNBT());
    event.shapeless('mekanism:creative_chemical_tank', Item.of('mekanism:creative_chemical_tank').ignoreNBT());

    //Unified quartz recipe
    event.recipes.mekanismCrushing('#forge:dusts/quartz', 'minecraft:quartz').id('mekanism:processing/quartz/to_dust')

    biofuel('thermal:glowstone_mushroom_spores', 5)
    biofuel('thermal:gunpowder_mushroom_spores', 5)
    biofuel('thermal:redstone_mushroom_spores', 5)
    biofuel('thermal:slime_mushroom_spores', 5)
    biofuel('farmersdelight:rice_panicle', 4)
    biofuel('farmersdelight:rice', 2)
    biofuel('thermal:barley', 5)
    biofuel('thermal:barley_seeds', 2)
    biofuel('thermal:corn', 6)
    biofuel('thermal:corn_seeds', 2)
    biofuel('thermal:flax', 5)
    biofuel('thermal:flax_seeds', 2)
    biofuel('thermal:onion', 4)
    biofuel('thermal:onion_seeds', 2)
    biofuel('thermal:eggplant', 5)
    biofuel('thermal:eggplant_seeds', 2)
    biofuel('thermal:coffee', 4)
    biofuel('thermal:coffee_seeds', 2)
    biofuel('thermal:radish', 4)
    biofuel('thermal:radish_seeds', 2)
    biofuel('thermal:rice', 4)
    biofuel('thermal:rice_seeds', 2)
    biofuel('thermal:sadiroot', 5)
    biofuel('thermal:sadiroot_seeds', 2)
    biofuel('thermal:tomato', 5)
    biofuel('thermal:tomato_seeds', 2)
    biofuel('thermal:hops', 4)
    biofuel('thermal:hops_seeds', 2)
    biofuel('thermal:strawberry', 5)
    biofuel('thermal:strawberry_seeds', 2)
    biofuel('thermal:peanut', 5)
    biofuel('thermal:peanut_seeds', 2)
    biofuel('thermal:green_bean', 4)
    biofuel('thermal:green_bean_seeds', 2)
    biofuel('thermal:tea', 4)
    biofuel('thermal:tea_seeds', 2)
    biofuel('thermal:bell_pepper', 4)
    biofuel('thermal:bell_pepper_seeds', 2)
    biofuel('thermal:spinach', 4)
    biofuel('thermal:spinach_seeds', 2)
    biofuel('thermal:frost_melon_slice', 4)
    biofuel('thermal:frost_melon_seeds', 2)
    biofuel('thermal:amaranth', 5)
    biofuel('thermal:amaranth_seeds', 2)
    biofuel('immersiveengineering:seed', 2)
    biofuel('ars_nouveau:magebloom', 4)
    biofuel('ars_nouveau:magebloom_crop', 2)
    biofuel('ars_nouveau:source_berry', 2)
    biofuel('farmersdelight:onion', 5)
    biofuel('farmersdelight:cabbage', 5)
    biofuel('farmersdelight:cabbage_seeds', 2)
    biofuel('farmersdelight:tomato', 5)
    biofuel('farmersdelight:tomato_seeds', 2)
    biofuel('cottonly:cotton_seeds', 2)
    biofuel('cottonly:ball', 4)

    //Ruby and Sapphire from oxidization, a real chemist can correct me likely. Fixes https://github.com/FTBTeam/FTB-Modpack-Issues/issues/1030
    event.recipes.mekanismPurifying('4x thermal:ruby', 'quark:red_corundum_cluster', {gas: 'mekanism:oxygen', amount: 2})
    event.recipes.mekanismPurifying('4x thermal:sapphire', 'quark:blue_corundum_cluster', {gas: 'mekanism:oxygen', amount: 2})

    //Solars recipe change
    event.shaped('mekanismgenerators:solar_panel', ['PPP', 'RAR', 'OOO'], {
        P: 'kubejsadditions:sheet_of_plexiglass',
        R: '#forge:dusts/redstone',
        A: '#forge:alloys/advanced',
        O: '#forge:ingots/osmium'
    }).id('mekanismgenerators:solar_panel')

    //Wind Generator recipe change
    event.shaped('mekanismgenerators:wind_generator', [' O ', 'ORO', 'BCB'], {
        B: '#forge:batteries',
        R: 'pneumaticcraft:turbine_rotor',
        C: '#forge:circuits/basic',
        O: '#forge:ingots/osmium'
    }).id('mekanismgenerators:generator/wind')
});